﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace IndianHealthService.BMXNet.WinForm.Configuration
{

    /// <summary>
    /// The persistent store interface is to save local setting configuration data.  The
    /// settings are written and read based on a string a keys, like a path.
    /// 
    /// The keys are application specific.  Some example could be: "Product","Version"
    /// 
    /// The location of the PersistentStore is based on the implementation.  The LocalPersistentStore
    /// provides the settings to be stored in special OS forlders like Environment.SpecialFolder.LocalApplicationData
    /// so that the settings would be based both on the logged in user and keys.
    /// </summary>
    public interface PersistentStore
    {

        /// <summary>
        /// The implementor must serialize the object anObject given the keys.
        /// </summary>
        /// <typeparam name="T">The type of the object to be serialized to the store</typeparam>
        /// <param name="anObject">The objects to be stored</param>
        /// <param name="keys">The key used to locate the settings</param>
        void Write<T>(T anObject, params string[] keys);

        /// <summary>
        /// The implementor must deserialize an object of type T from the given location based
        /// on the keys
        /// </summary>
        /// <typeparam name="T">The type of the object to be deserialized from the store</typeparam>
        /// <param name="keys">The keys used to locate the object</param>
        /// <returns>An deserialized object, or null if no valid objects exists at the keys</returns>
        T Read<T>(params string[] keys);       
    }
}
